<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('username', 'email', 'mobile');
    protected $visible = array('username', 'email', 'mobile');
    protected $hidden = array('register_ip', 'forget_token', 'active_token');

    public function orders()
    {
        return $this->hasMany('Order', 'user_id');
    }

    public function userRewardPoints()
    {
        return $this->hasMany('UserRewardPoint', 'user_id');
    }

    public function userAddress()
    {
        return $this->hasMany('UserAddress', 'user_id');
    }

    public function userDetail()
    {
        return $this->hasMany('UserDetail', 'user_id');
    }

    public function userAccount()
    {
        return $this->hasMany('UserPayment', 'user_id');
    }

    public function reviews()
    {
        return $this->hasMany('Review', 'user_id');
    }

}